/*
 * DMCMethodDialog.java
 *
 * Author: Martin Christian <martin@christianix.de>
 * Created on 14. Mai 2003, 00:00
 */

package parser;

/**
 *
 * @author  mai01edz
 */
public class DMCMethodDialog extends javax.swing.JDialog {

	private double alpha;
	private double partitioning;
	private boolean canceled;

	/** Creates new form DMCMethodDialog */
	public DMCMethodDialog(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
		this.alpha = 0.95;
		this.partitioning = 0.0;
		this.canceled = false;
		this.t_alpha.setText( String.valueOf(this.alpha) );
		this.t_partition.setText( String.valueOf(this.partitioning) );
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
  private void initComponents() {//GEN-BEGIN:initComponents
    p_top = new javax.swing.JPanel();
    l_title = new javax.swing.JLabel();
    p_middle = new javax.swing.JPanel();
    p_middle_n = new javax.swing.JPanel();
    l_alpha = new javax.swing.JLabel();
    t_alpha = new javax.swing.JTextField();
    p_middle_m = new javax.swing.JPanel();
    cb_train = new javax.swing.JCheckBox();
    cb_apply = new javax.swing.JCheckBox();
    p_middle_s = new javax.swing.JPanel();
    l_partition = new javax.swing.JLabel();
    t_partition = new javax.swing.JTextField();
    p_bottom = new javax.swing.JPanel();
    b_ok = new javax.swing.JButton();
    b_cancel = new javax.swing.JButton();

    setTitle("DMC 2003");
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        closeDialog(evt);
      }
    });

    l_title.setFont(new java.awt.Font("Dialog", 1, 18));
    l_title.setText("Method Parameters");
    p_top.add(l_title);

    getContentPane().add(p_top, java.awt.BorderLayout.NORTH);

    p_middle.setLayout(new java.awt.BorderLayout());

    l_alpha.setText("        Alpha =");
    l_alpha.setToolTipText("Threshold probability for cut-off");
    p_middle_n.add(l_alpha);

    t_alpha.setToolTipText("Threshold probability for cut-off");
    t_alpha.setPreferredSize(new java.awt.Dimension(80, 20));
    p_middle_n.add(t_alpha);

    p_middle.add(p_middle_n, java.awt.BorderLayout.NORTH);

    cb_train.setSelected(true);
    cb_train.setText("Train");
    p_middle_m.add(cb_train);

    cb_apply.setSelected(true);
    cb_apply.setText("Apply");
    p_middle_m.add(cb_apply);

    p_middle.add(p_middle_m, java.awt.BorderLayout.CENTER);

    l_partition.setText("Partitioning =");
    l_partition.setToolTipText("Partitioning ration of data");
    p_middle_s.add(l_partition);

    t_partition.setToolTipText("Partitioning ration of data");
    t_partition.setPreferredSize(new java.awt.Dimension(80, 20));
    p_middle_s.add(t_partition);

    p_middle.add(p_middle_s, java.awt.BorderLayout.SOUTH);

    getContentPane().add(p_middle, java.awt.BorderLayout.CENTER);

    b_ok.setText("Ok");
    b_ok.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        b_okActionPerformed(evt);
      }
    });

    p_bottom.add(b_ok);

    b_cancel.setText("Cancel");
    b_cancel.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        b_cancelActionPerformed(evt);
      }
    });

    p_bottom.add(b_cancel);

    getContentPane().add(p_bottom, java.awt.BorderLayout.SOUTH);

    pack();
  }//GEN-END:initComponents

	private void b_cancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_b_cancelActionPerformed
		this.canceled = true;
		setVisible(false);
		dispose();
	}//GEN-LAST:event_b_cancelActionPerformed

	private void b_okActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_b_okActionPerformed
		setVisible(false);
		dispose();
	}//GEN-LAST:event_b_okActionPerformed
	
	/** Closes the dialog */
	private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
		setVisible(false);
		dispose();
	}//GEN-LAST:event_closeDialog

	public double getAlpha() throws NumberFormatException {
		this.alpha = Double.parseDouble( this.t_alpha.getText() );
		return this.alpha;
	}	

	public double getPartitioning() {
		try {
			this.partitioning = Double.parseDouble( this.t_partition.getText() );
		}
		catch ( NumberFormatException nfe ) {
			System.err.println( "Partitioning not a valid double! I'll ignore it..." );
		}
		return this.partitioning;
	}

	public boolean isCanceled() {
		return this.canceled;
	}

	public boolean isTraining() {
		return this.cb_train.isSelected();
	}

	public boolean isApplication() {
		return this.cb_apply.isSelected();
	}

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel l_alpha;
  private javax.swing.JTextField t_alpha;
  private javax.swing.JPanel p_middle_n;
  private javax.swing.JLabel l_title;
  private javax.swing.JCheckBox cb_apply;
  private javax.swing.JPanel p_middle_s;
  private javax.swing.JTextField t_partition;
  private javax.swing.JLabel l_partition;
  private javax.swing.JPanel p_bottom;
  private javax.swing.JPanel p_middle;
  private javax.swing.JCheckBox cb_train;
  private javax.swing.JPanel p_middle_m;
  private javax.swing.JButton b_ok;
  private javax.swing.JButton b_cancel;
  private javax.swing.JPanel p_top;
  // End of variables declaration//GEN-END:variables
	
}
