/*
 * DMCStatistics.java
 *
 * Author: Martin Christian <martin@christianix.de>
 * Created on 22. April 2003, 01:55
 */
package parser;

import java.util.Arrays;

/**
 *
 * @author  mai01edz
 */
public class DMCStatistics {

	protected DMCDataset dataset;
	protected double[] mailprobabilities;
	protected int[] spamids;
	protected int error_spam;
	protected int error_nospam;

	/** Creates a new instance of DMCStatistics */
	public DMCStatistics( DMCDataset dataset, double[] probab, int[] spamids ) {
		int[] vector;
		int i, n, m;

		this.dataset = dataset;
		Arrays.sort( spamids );

		if ( dataset.isValidation() ) {
			this.mailprobabilities = probab;
			this.spamids = spamids;
			this.error_spam = 0;
			this.error_nospam = 0;
		}
		else {
			this.mailprobabilities = probab;
			this.spamids = spamids;
			this.error_spam = 0;
			this.error_nospam = 0;
  		// test mails
			System.out.print("Testing mails...");
			n = dataset.getN();
			m = dataset.getAttributes().length - 1;
			for ( i=0; i<n; i++ ) {
				vector = dataset.getRow( i );
				if ( vector[m] == 1 ) {
					if ( Arrays.binarySearch(spamids, vector[0]) < 0 )
						this.error_spam++;
				}
				else {
					if ( Arrays.binarySearch(spamids, vector[0]) >= 0 )
						this.error_nospam++;
				}
			}
			System.out.println("done.");
		}
	}

	public String toString() {
		int n = dataset.getN();
		StringBuffer sb = new StringBuffer( n * 4 );
		sb.append( "[ " );
		for ( int i = 0; i<n; i++ ) {
			sb.append( this.mailprobabilities[i] );
			sb.append( " | " );
		}
		sb.delete( sb.length()-2, sb.length() );
		sb.append( "]" );
		return sb.toString();
	}

	public int getFalseSpam() {
		return this.error_spam;
	}

	public double getSpamError() {
		return (double)this.error_spam / (double)this.dataset.getSpam();
	}

	public int getFalseNoSpam() {
		return this.error_nospam;
	}

	public double getNoSpamError() {
		return (double)this.error_nospam / (double)this.dataset.getNoSpam();
	}

	public int getTotal() {
		return this.dataset.getN();
	}

	public int[] getSpamIDs() {
		return this.spamids;
	}

	public double[] getMailProbabilities() {
		return this.mailprobabilities;
	}
	
	public DMCDataset getDataset() {
		return this.dataset;
	}
}
