/*********************************************************************
 *                                                                   *
 *                     Generic List                                  *
 *                                                                   *
 *  Author:  Martin Christian                                        *
 *  Date:    13/04/03                                                *
 *  Licence: LGPL                                                    *
 *********************************************************************/

typedef struct listframe {
    void *content;
    struct listframe *prev;
    struct listframe *next;
} LISTFRAME;

/*
 * Initializes list.
 */
void list_init();

/*
 * Frees memory used by the element containers of the list.
 * It does not free the memory used by the elements!!!!
 */
void list_destroy();

/*
 * Inserts an element at the end of the list.
 *
 * Parameter: content = element to insert
 * Return:    0 on success
 */
int list_insert( void* );

/*
 * Remove an element from the list.
 * The first element is at position 0.
 *
 * Parameter: Position of element to remove
 * Returns:   0 on success.
 */
int list_remove( int );

/*
 * Get an element from the list.
 * The first element is at position 0.
 *
 * Parameter: Position of requested element
 * Returns:   element of the list.
 */
void* list_get( int );

/*
 * Returns element count.
 */
int list_get_count();

/*
 * Returns last element of the list.
 */
LISTFRAME* list_top();

/*
 * Returns last element of the list.
 */
LISTFRAME* list_bottom();
